/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.evaluation.Evaluation;
import weka.core.Instances;
import weka.test.Regression;

public class EvaluationTest
extends TestCase {
    public static final String DATA = "@relation test\n@attribute one numeric\n@attribute two numeric\n@attribute class {T, F}\n@data\n\n6.5,3.0,T\n6.2,3.4,T\n5.9,3.0,T\n7.0,3.2,F\n6.4,3.2,F\n6.9,3.1,F\n";
    public static final double[][] PREDS = new double[][]{{0.231, 0.769}, {1.0, 0.0}, {0.956, 0.044}, {0.013, 0.987}, {0.484, 0.516}, {0.068, 0.932}};

    public EvaluationTest(String name) {
        super(name);
    }

    public void testRegression() throws Exception {
        Instances inst = new Instances(new StringReader(DATA));
        inst.setClassIndex(inst.numAttributes() - 1);
        Evaluation eval = new Evaluation(inst);
        int i = 0;
        while (i < inst.numInstances()) {
            eval.evaluateModelOnceAndRecordPrediction(PREDS[i], inst.instance(i));
            ++i;
        }
        String standard = eval.toSummaryString();
        String info = eval.toClassDetailsString();
        Regression reg = new Regression(this.getClass());
        reg.println(standard);
        reg.println(info);
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                EvaluationTest.fail("Regression tst failed. Difference:\n" + diff);
            }
        }
        catch (IOException ex) {
            EvaluationTest.fail("Problem during regression testing.\n" + ex);
        }
    }

    public static Test suite() {
        return new TestSuite(EvaluationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(EvaluationTest.suite());
    }
}

